/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.utility;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.skloch.game.HustleGame;
import com.skloch.game.gamelogic.DialogueBox;
import com.skloch.game.gamelogic.EventManager;
import com.skloch.game.gamelogic.Player;
import com.skloch.game.screens.GameScreen;

public class CustomInputAdapter {
    private HustleGame game;
    private DialogueBox dialogueBox;
    private EventManager eventManager;
    private Player player;
    private Window escapeMenu;
    private GameScreen screen;

    public CustomInputAdapter(HustleGame game, DialogueBox dialogueBox, EventManager eventManager, Player player, Window escapeMenu, GameScreen screen) {
        this.game = game;
        this.dialogueBox = dialogueBox;
        this.eventManager = eventManager;
        this.player = player;
        this.escapeMenu = escapeMenu;
        this.screen = screen;
    }

    public InputAdapter makeInputAdapter() {
        return new InputAdapter(){

            @Override
            public boolean keyDown(int keycode) {
                if (keycode == 111) {
                    if (CustomInputAdapter.this.escapeMenu.isVisible()) {
                        ((CustomInputAdapter)CustomInputAdapter.this).game.soundManager.playButton();
                        ((CustomInputAdapter)CustomInputAdapter.this).game.soundManager.playOverworldMusic();
                        CustomInputAdapter.this.escapeMenu.setVisible(false);
                    } else {
                        ((CustomInputAdapter)CustomInputAdapter.this).game.soundManager.playButton();
                        CustomInputAdapter.this.escapeMenu.setVisible(true);
                    }
                    return true;
                }
                if (!(keycode != 33 && keycode != 66 && keycode != 62 || CustomInputAdapter.this.escapeMenu.isVisible())) {
                    if (CustomInputAdapter.this.dialogueBox.isVisible()) {
                        CustomInputAdapter.this.dialogueBox.enter(CustomInputAdapter.this.eventManager);
                        ((CustomInputAdapter)CustomInputAdapter.this).game.soundManager.playButton();
                    } else if (CustomInputAdapter.this.player.nearObject() && !((CustomInputAdapter)CustomInputAdapter.this).screen.sleeping && !((CustomInputAdapter)CustomInputAdapter.this).screen.fadeout) {
                        if (CustomInputAdapter.this.player.getClosestObject().get("event") != null) {
                            CustomInputAdapter.this.dialogueBox.show();
                            CustomInputAdapter.this.dialogueBox.getSelectBox().setOptions(new String[]{"Yes", "No"}, new String[]{(String)CustomInputAdapter.this.player.getClosestObject().get("event"), "exit"});
                            if (CustomInputAdapter.this.eventManager.hasCustomObjectInteraction((String)CustomInputAdapter.this.player.getClosestObject().get("event"))) {
                                CustomInputAdapter.this.dialogueBox.setText(CustomInputAdapter.this.eventManager.getObjectInteraction((String)CustomInputAdapter.this.player.getClosestObject().get("event")));
                            } else {
                                CustomInputAdapter.this.dialogueBox.setText("Interact with " + CustomInputAdapter.this.player.getClosestObject().get("event") + "?");
                            }
                            CustomInputAdapter.this.dialogueBox.show();
                            CustomInputAdapter.this.dialogueBox.getSelectBox().show();
                            ((CustomInputAdapter)CustomInputAdapter.this).game.soundManager.playDialogueOpen();
                        } else if (CustomInputAdapter.this.player.getClosestObject().get("text") != null) {
                            CustomInputAdapter.this.dialogueBox.show();
                            CustomInputAdapter.this.dialogueBox.setText((String)CustomInputAdapter.this.player.getClosestObject().get("text"));
                        }
                    }
                    return true;
                }
                if (CustomInputAdapter.this.dialogueBox.isVisible() && CustomInputAdapter.this.dialogueBox.getSelectBox().isVisible() && !CustomInputAdapter.this.escapeMenu.isVisible()) {
                    if (keycode == 51 || keycode == 19) {
                        CustomInputAdapter.this.dialogueBox.getSelectBox().choiceUp();
                    } else if (keycode == 47 || keycode == 20) {
                        CustomInputAdapter.this.dialogueBox.getSelectBox().choiceDown();
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

